//=============================================================================
// MS_ComputerScreenLogin
// Script by Steve Tack
//=============================================================================

class MS_ComputerScreenLogin expands ComputerScreenLogin;

// This function is overridden to call MyComputers so that custom
// logos and text can appear on the computer login window

// ----------------------------------------------------------------------
// SetCompOwner()
// ----------------------------------------------------------------------

function SetCompOwner(ElectronicDevices newCompOwner)
{

	Super.SetCompOwner(newCompOwner);

	// Update the title, texture and description
	winTitle.SetTitle(Sprintf(Title, MS_Computers(compOwner).GetNodeName()));
	winLoginInfo.SetText(MS_Computers(compOwner).GetNodeDesc());

	SetFocusWindow(editUserName);

	SetLogo(MS_Computers(compOwner).GetNodeTexture());
}

defaultproperties
{
}
